(function(exports){
	'use strict'
	
	exports.ask_hex = function(prompt, len) {
		var num=ui.ask(prompt);
		if (! num) return "Отменено";
		
		if (! num.match(/^-?[0-9A-Fa-f]+$/)) return "Неверный формат числа";
		if (num.length > len) return "Неверное число (допустимо "+len+" символов)";
		
		return parseInt(num, 16);
	};

	exports.ask_dec = function(prompt,min_len,max_len) {
		var num=ui.ask(prompt);
		if (! num) return "Отменено";

		if (! num.match(/^-?[0-9]+$/)) 
			return 	{
						status: false,
						message: "Неверный формат числа\n"
					};
		if (num.length > max_len)
			return 	{
						status: false,
						message: "Длина серийного номера больше " +max_len+ " символов\n"
					};
		if (num.length < min_len)
			return 	{
						status: false,
						message: "Длина серийного номера меньше " +min_len+ " символов\n"
					};
		return 	{
					status: true,
					message: num
				};
	}
	
	
	exports.toHex = function(num, len) {
		var s=""+(~~num).toString(16);
		while (s.length < len)
			s='0'+s;
		return s.toUpperCase();
	}
	
	
	// Распаковать файлы из zip-архива
	exports.unzip = function(zip, dir, files) {
		var args = [ '-d', dir, zip ];
		if (files) files.forEach( function(name) { args.push(name); } );
		if (system.exec( (system.os == 'windows') ? 'utils/unzip.exe' : 'unzip', args, print, print) != 0)
			throw new Error("Unzip failed");
	}
	
	
	// Удалить каталог с подкаталогами и файлами
	exports.rm_r = function(dir) {
		if (! dir.endsWith('/'))
			dir+='/';
		
		var list=fs.readdir(dir);
		list.forEach( function(fname) {
				if (fname.endsWith('/'))
					exports.rm_r(dir+fname); else
					fs.remove(dir+fname);
			} );
		fs.rmdir(dir);
	}
	
	
	// Перекодировать строку введенную в русской раскладке
	exports.fixRus = function(str) {
		var isRus=false;
		for (var i=0; i<str.length; i++)
		{
			if (str.charCodeAt(i) >= 128)
			{
				isRus=true;
				break;
			}
		}
		if (! isRus) return str;
		
		var rus="ёйцукенгшщзхъфывапролджэячсмитьбюЁЙЦУКЕНГШЩЗХЪФЫВАПРОЛДЖЭЯЧСМИТЬБЮ\"№;:?,";
		var eng="`qwertyuiop[]asdfghjkl;'zxcvbnm,.~QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>@#$^&?";
		
		var str2="";
		for (var i=0; i<str.length; i++)
		{
			var n=rus.indexOf(str.charAt(i));
			if (n < 0)
				str2+=str.charAt(i); else
				str2+=eng.charAt(n);
		}
		return str2;
	}
	
})(typeof exports === 'undefined' ? this['_utils_js']={} : exports);
