(function(exports){
	'use strict'
	
	var auth_ok=false;
	var url="https://get.serial.rubetek.com/rpc.php"
	var sid="";
	var rpc_id=0;
	var unfinished={};
	
	
	function rpc(message, method, params)
	{
		rpc_id++;
		
		// Собираем запрос
		var json={
			jsonrpc: "2.0",
			method: method,
			params: params,
			id: rpc_id,
		};
		fs.write("tmp/post.bin", JSON.stringify(json));
		
		// Отправляем запрос
		if (net.httpPost(url+"?"+sid, "tmp/post.bin", "tmp/get.bin", message, { "Content-Type": "application/json" }) != 200)
			throw new Error("RPC failed");
		
		// Читаем ответ
		json=fs.read("tmp/get.bin");
		try
		{
			json=JSON.parse(json);
		} catch (e)
		{
			print("Bad JSON: '"+json+"'");
			throw new Error("Bad JSON");
		}
		
		// Проверяем поля
		if (json.jsonrpc != "2.0") throw new Error("Bad jsonrpc version");
		if (json.id != rpc_id) throw new Error("jsonrpc id mismatch");
		if ('error' in json)
		{
			if (json.code == -32000) auth_ok=false;
			throw new Error("RPC error: "+json.error.message);
		}
		if (! ('result' in json)) throw new Error("No 'result' in JSON");
		
		// Обновляем сессию
		if ('sid' in json)
			sid=""+json.sid;
		
		// Готово
		return json.result;
	}
	
	
	exports.auth = function() {
		if (auth_ok) return true;
		
		var login=ui.login("Авторизация");
		if (! login) return false;
		
		auth_ok=rpc("Авторизация...", "auth", login);
		
		return auth_ok;
	};
	
	
	exports.get = function(devType) {
		if (! (devType in unfinished))
			unfinished[devType]=rpc("Запрос серийного номера...", "get_serial", devType);
		
		return unfinished[devType];
	};
	
	
	exports.finish = function(devType, serial, serial_text, hw_rev, fw_rev) {
		delete unfinished[devType];
		return rpc("Обновление базы...", "serial_ok", [ devType, serial, serial_text, hw_rev, fw_rev ]);
	}
	
})(typeof exports === 'undefined' ? this['_serial_js']={} : exports);
