(function(exports){
	'use strict'
	
	var part="stm8s003f3p6";
	
	
	exports.run = function(firmware, params) {
		
		ui.progress(0);
		
		var ihex=require("scripts/IntelHex");
		var stm8flash=require("scripts/stm8");
		
		// Получаем индекс
		var index;
		try
		{
			if (params.length != 1) throw new Error("bad params length");
			index=parseInt(params[0]);
			if ( (index < 0) || (index > 2047) ) throw new Error("bad number");
		} catch (e)
		{
			print(e+"\n");
			return "Неверный QR-код !";
		}
		
		// Загружаем файл прошивки
		var fw=ihex.load(firmware, [ { address: 0x8000, size: 8192 }, { address: 0x4000, size: 128 } ]);
		
		// Устанавливаем индекс
		fw[1].data[0]=(index >> 8) & 0xff;
		fw[1].data[1]=index & 0xff;
		
		// Сохраняем прошивки в файлы
		fs.writeBinary("tmp/flash.bin", fw[0].data);
		fs.writeBinary("tmp/eeprom.bin", fw[1].data);
		
		// Разблокируем проц
		if (! stm8flash.unlock(part))
		{
			return "Ошибка при разблокировке !";
		}
		ui.progress(10);
		
		// Записываем eeprom
		if (! stm8flash.write(part, "eeprom", "tmp/eeprom.bin"))
		{
			return "Ошибка при прошивке EEPROM !";
		}
		ui.progress(20);
		
		// Проверяем eeprom
		if (! stm8flash.verify(part, "eeprom", "tmp/eeprom.bin"))
		{
			return "Ошибка при проверке EEPROM !";
		}
		ui.progress(30);
		
		// Записываем flash
		if (! stm8flash.write(part, "flash", "tmp/flash.bin"))
		{
			return "Ошибка при прошивке Flash !";
		}
		ui.progress(80);
		
		// Проверяем flash
		if (! stm8flash.verify(part, "flash", "tmp/flash.bin"))
		{
			return "Ошибка при проверке Flash !";
		}
		ui.progress(100);
		
		// Удаляем временные файлы
		fs.remove("tmp/flash.bin");
		fs.remove("tmp/eeprom.bin");
		
		
		// Успешно
		return "";
	};
	
})(typeof exports === 'undefined' ? this['_qr_pls_dev_js']={} : exports);
