(function(exports){
	'use strict'
	
	var total_files, file_n;
	var flash_ok, flash_str="";
	
	
	function stdout_line(text)
	{
		print("stdout: '"+text+"'\n");
		if (text.match(/^Hash of data verified.$/))
			file_n++;
		
		var p=/^Writing at .* \((\d+) %\)$/.exec(text);
		if (p)
		{
			ui.progress(100 * file_n / total_files + (~~p[1]) / total_files);
		}
	}
	
	
	function stdout(text)
	{
		text=text.replace(/\r/g, '\n');
		var nl;
		while ( (nl=text.indexOf('\n')) >= 0 )
		{
			stdout_line(flash_str + text.substring(0, nl));
			flash_str="";
			text=text.substring(nl+1);
		}
		flash_str=text;
	}
	
	
	exports.burn = function(firmware, spi_mode, flash_size, sections) {
		
		ui.progress(-1);
		
		// Создаем временный каталог
		try
		{
			Utils.rm_r("tmp/zip");
		} catch (e){}
		fs.mkdir("tmp/zip");
		
		// Распаковываем прошивку
		Utils.unzip(firmware, "tmp/zip/");
		
		// Собираем параметры для флэшера
		var args = [
			'-p', COM, '-b', '460800',
			'--before', 'default_reset',
			'--after', 'hard_reset',
			'write_flash',
			'--flash_mode', spi_mode,
			'--flash_size', flash_size,
			'--flash_freq', '40m' ];
		if (sections instanceof Array)
		{
			args=args.concat(sections);
		}
		
		// Добавляем прошивки
		file_n=0;
		total_files=2;
		fs.readdir("tmp/zip/").forEach( function(name) {
				var e=/(0x[0-9A-Fa-f]+)\.bin$/.exec(name);
				if (e)
				{
					args.push(e[1]);
					args.push("tmp/zip/"+name);
					total_files++;
				}
			});
		
		// Зашиваем
		if ( (system.exec( (system.os == 'windows') ? 'flashers/esptool/esptool.exe' : 'esptool.py', args, stdout, stdout ) != 0) || (file_n != total_files) )
			return false;
		
		// Удаляем временный каталог
		try
		{
			Utils.rm_r("tmp/zip");
		} catch (e){}
		
		// Успешно
		return true;
	};
	
	
	exports.ui_burn = function(firmware, spi_mode, flash_size, sections) {
		
		ui.progress(0);
		
		// Запрашиваем COM-порт
		if (! selectCom()) return "";
		
		// Прошиваем
		if (! exports.burn(firmware, spi_mode, flash_size, sections)) return "Ошибка программирования";
		
		// Готово
		return "";
	};
	
})(typeof exports === 'undefined' ? this['_esptool_js']={} : exports);
