(function(exports){
	'use strict'
	
	function stm8l151_id()
	{
		if (! stm8.read("stm8l151g4", "0x4926", "tmp/cpuid.bin", 12)) throw new Error("STM8 read error");
		return fs.readBinary("tmp/cpuid.bin");
	}
	
	
	function stm32f2xx_id()
	{
		if (! stm32.read("tmp/cpuid.bin", "0x1FFF7A10", 12)) throw new Error("STM32 read error");
		return fs.readBinary("tmp/cpuid.bin");
	}
	
	
	
	exports.stm8l151_afas_id = function() {
		var uid=stm8l151_id();
		var serial=[ crc.crc8(uid, 4, 8), uid[0] ^ uid[1], uid[2] ^ uid[3] ];
		return Utils.toHex(serial[0], 2) + Utils.toHex(serial[1], 2) + Utils.toHex(serial[2], 2);
	};
	
	
	exports.stm32f2xx_uuid = function() {
		var uid=stm32f2xx_id();
		for (var i=0; i<6; i++)
			uid[i]^=uid[6+i];
		var s="";
		for (var i=0; i<12; i++)
			s+=Utils.toHex(uid[i], 2);
		return (s.substring(0, 8) + '-' + s.substring(8, 12) + '-4000-8000-' + s.substring(12)).toLowerCase();
	}
	
	
	exports.stm32f2xx_serial32 = function() {
		var uid=stm32f2xx_id();
		var id32=(unpack.u32(uid, 0) + unpack.u32(uid, 4) + unpack.u32(uid, 8)) & 0xffffffff;
		return Utils.toHex(id32, 8);
	}
	
})(typeof exports === 'undefined' ? this['_cpuid_js']={} : exports);
