(function(exports){
	'use strict'
	
	// Положение серийника
	var SERIAL_AT = 8192-3;
	
	
	exports.PLS3_dev = function(firmware) {
		ui.progress(-1);
		
		// Запрашиваем серийник
		var serial=Utils.ask_hex("Введите серийный номер:", 6);
		if ((typeof serial) != 'number') return serial;
		
		// Читаем прошивку
		var bin=fs.readBinary(firmware);
		
		// Устанавливаем серийник
		pack.u8((serial >> 16) & 0xff, bin, SERIAL_AT+0);
		pack.u8((serial >> 8) & 0xff, bin, SERIAL_AT+1);
		pack.u8(serial & 0xff, bin, SERIAL_AT+2);
		
		// Записываем во временный файл
		fs.writeBinary("tmp/pls3_dev.bin", bin);
		
		// Зашиваем
		ui.progress(0);
		print("Burning...\n");
		if (! stm8.write("stm8s003f3p6", "flash", "tmp/pls3_dev.bin")) return "Ошибка записи в чип";
		ui.progress(50);
		
		print("Verifying...\n");
		if (! stm8.verify("stm8s003f3p6", "flash", "tmp/pls3_dev.bin")) return "Ошибка проверки записи";
		ui.progress(100);
		
		// Успешно
		return "";
	};
	
})(typeof exports === 'undefined' ? this['_pls3_devs_js']={} : exports);
