(function(exports){
	'use strict'
	
	// Положение серийника
	var SERIAL_AT = 0x7F0;
	
	
	exports.PLS3_AEX = function(firmware, fw_rev, online) {
		var devType="afas_pls3_amr4_stm32f030";
		var hw_rev="AMR4-STM32F030";
		
		ui.progress(-1);
		
		var serial_no;
		
		if (online)
		{
			// Авторизируемся
			if (! Serial.auth()) return "Ошибка авторизации";
			
			// Запрашиваем серийник
			var serial;
			try
			{
				serial=Serial.get(devType);
			} catch (e)
			{
				return "Ошибка получения серийного номера";
			}
			var serial_no=((serial << 4) + 0x300000) & 0xffffff;
		} else
		{
			// Запрашиваем серийник
			var num=ui.ask("Введите серийный номер (QR или 5 цифр):");
			if (! num) return "";
			num=Utils.fixRus(num);
			if (num.length == 5)
			{
				// Просто серийник
				if (! num.match(/^-?[0-9A-Fa-f]+$/)) return "Неверный формат числа";
				serial_no=parseInt(num, 16);
			} else
			{
				// QR
				var json;
				try
				{
					json=JSON.parse(num);
				} catch (e)
				{
					return "Неверный формат QR-кода";
				}
				
				if (json.model != "AMR-4") return "QR-код от другого устройства";
				if ( ("string" != typeof json.id) ||
					 (json.id.length != 5) ||
					 (! json.id.match(/^-?[0-9A-Fa-f]+$/)) )
					return "Неверный форма ID";
				
				serial_no=parseInt(json.id, 16);
			}
			
			serial_no<<=4;
		}
		
		
		// Читаем прошивку
		var bin=fs.readBinary(firmware);
		
		// Устанавливаем серийник
		pack.u8((serial_no >> 16) & 0xff, bin, SERIAL_AT+0);
		pack.u8((serial_no >> 8) & 0xff, bin, SERIAL_AT+1);
		pack.u8(serial_no & 0xff, bin, SERIAL_AT+2);
		
		// Записываем во временный файл
		fs.writeBinary("tmp/pls3_aex.bin", bin);
		
		// Зашиваем
		ui.progress(-1);
		print("Burning...\n");
		if (! stm32.write("tmp/pls3_aex.bin")) return "Ошибка записи в чип";
		ui.progress(100);
		
		if (online)
		{
			// Отправляем запрос на обновление базы
			if (! Serial.finish(devType, serial, Utils.toHex(serial_no, 6), hw_rev, fw_rev)) return "Ошибка обновления базы";
		}
		
		// Успешно
		return "";
	};
	
})(typeof exports === 'undefined' ? this['_pls3_aex_js']={} : exports);
