(function(exports){
	'use strict'
	
	// Положение конфигурации
	var CONFIG_AT = 0x08000;
	
	
	exports.RF_dev = function(firmware) {
		ui.progress(-1);
		
		// Запрашиваем серийник
		var serial=Utils.ask_hex("Введите серийный номер:", 6);
		if ((typeof serial) != 'number') return serial;
		
		// Зашиваем
		if (! nRFflash.write(firmware, serial)) return "Ошибка записи в чип";
		
		// Успешно
		return "";
	};
	
	
	exports.RF_dev_online = function(firmware, devType, hw_rev, fw_rev) {
		ui.progress(-1);
		
		// Авторизируемся
		if (! Serial.auth()) return "Ошибка авторизации";
		
		// Запрашиваем серийник
		var serial;
		try
		{
			serial=Serial.get(devType);
		} catch (e)
		{
			return "Ошибка получения серийного номера";
		}
		var serial_no=(serial + 0x300000) & 0xffffff;
		
		// Зашиваем
		if (! nRFflash.write(firmware, serial_no)) return "Ошибка записи в чип";
		
		// Отправляем запрос на обновление базы
		if (! Serial.finish(devType, serial, Utils.toHex(serial_no, 6), hw_rev, fw_rev)) return "Ошибка обновления базы";
		
		// Успешно
		return "";
	};
	
	
	exports.RR = function(firmware) {
		ui.progress(-1);
		
		// Зашиваем
		if (! nRFflash.write(firmware)) return "Ошибка записи в чип";
		
		// Успешно
		return "";
	};
	
	
	exports.RR_cmt = function(firmware) {
		ui.progress(-1);
		
		// Запрашиваем серийник
		var serial=Utils.ask_hex("Введите серийный номер:", 6);
		if ((typeof serial) != 'number') return serial;
		
		// Читаем файл и добавляем в него серийник
		var bin=fs.readBinary(firmware);
		pack.u8((serial >> 24) & 0xff, bin, 0xffd);
		pack.u8((serial >> 16) & 0xff, bin, 0xffe);
		pack.u8(serial & 0xff, bin, 0xfff);
		fs.writeBinary("tmp/nrf9e5.bin", bin);
		
		// Зашиваем
		if (! nRFflash.write("tmp/nrf9e5.bin")) return "Ошибка записи в чип";
		
		// Удаляем временный файл
		fs.remove("tmp/nrf9e5.bin");
		
		// Успешно
		return "";
	};
	
	
	exports.RR_cmt_online = function(firmware, fw_rev) {
		var devType="afas_nrf_rr_cmtproto";
		var hw_rev="RR v1.0";
		
		ui.progress(-1);
		
		// Авторизируемся
		if (! Serial.auth()) return "Ошибка авторизации";
		
		// Запрашиваем серийник
		var serial;
		try
		{
			serial=Serial.get(devType);
		} catch (e)
		{
			return "Ошибка получения серийного номера";
		}
		var serial_no=(serial + 0x300000) & 0xffffff;
		
		// Читаем файл и добавляем в него серийник
		var bin=fs.readBinary(firmware);
		pack.u8((serial_no >> 24) & 0xff, bin, 0xffd);
		pack.u8((serial_no >> 16) & 0xff, bin, 0xffe);
		pack.u8(serial_no & 0xff, bin, 0xfff);
		fs.writeBinary("tmp/nrf9e5.bin", bin);
		
		// Зашиваем
		if (! nRFflash.write(firmware)) return "Ошибка записи в чип";
		
		// Удаляем временный файл
		fs.remove("tmp/nrf9e5.bin");
		
		// Отправляем запрос на обновление базы
		if (! Serial.finish(devType, serial, Utils.toHex(serial_no, 6), hw_rev, fw_rev)) return "Ошибка обновления базы";
		
		// Успешно
		return "";
	};
	
})(typeof exports === 'undefined' ? this['_nrf_devs_js']={} : exports);
