(function(exports){
	'use strict'
	
	// Положение серийника
	var SERIAL_AT = 0x7F0;
	
	
	exports.MDA_R = function(firmware, model) {
		
		ui.progress(-1);
		
		var serial_no;
		
		// Запрашиваем серийник
		var num=ui.ask("Введите серийный номер (QR или 6 цифр):");
		if (! num) return "";
		num=Utils.fixRus(num);
		if (num.length == 6)
		{
			// Просто серийник
			if (! num.match(/^-?[0-9A-Fa-f]+$/)) return "Неверный формат числа";
			serial_no=parseInt(num, 16);
		} else
		{
			// QR
			var json;
			try
			{
				json=JSON.parse(num);
			} catch (e)
			{
				return "Неверный формат QR-кода";
			}
			
			if (json.model != model) return "QR-код от другого устройства";
			if ( ("string" != typeof json.id) ||
				 (json.id.length != 6) ||
				 (! json.id.match(/^-?[0-9A-Fa-f]+$/)) )
				return "Неверный форма ID";
			
			serial_no=parseInt(json.id, 16);
		}
		
		
		// Читаем прошивку
		var bin=fs.readBinary(firmware);
		
		// Устанавливаем серийник
		pack.u8((serial_no >> 16) & 0xff, bin, SERIAL_AT+0);
		pack.u8((serial_no >> 8) & 0xff, bin, SERIAL_AT+1);
		pack.u8(serial_no & 0xff, bin, SERIAL_AT+2);
		
		// Записываем во временный файл
		fs.writeBinary("tmp/mda_r.bin", bin);
		
		// Зашиваем
		ui.progress(-1);
		print("Burning...\n");
		if (! stm32.write("tmp/mda_r.bin")) return "Ошибка записи в чип";
		ui.progress(100);
		
		
		// Успешно
		return "";
	};
	
})(typeof exports === 'undefined' ? this['_mda_r_js']={} : exports);
