(function(exports){
	'use strict'
	
	// Положение конфигурации и сертификатов
	var CONFIG_AT	= 0x08000;
	var CA_AT		= 0x0C000;
	var CERT_AT		= 0x0C800;
	var KEY_AT		= 0x0D000;
	
	
	// RPC
	var get_certs = (new jsonrpc.RPC("https://test.devices.rubetek.com/api/v1/certificates", [ 'get_certs' ] )).get_certs;
	var flash_result = (new jsonrpc.RPC("https://test.devices.rubetek.com/api/v1/products", [ 'flash_result' ] )).flash_result;
	
	
	
	exports.burn = function(firmware, config, version) {
		
		ui.progress(0);

		// Читаем прошивку и добавляем в нее конфигурацию
		var bin = fs.readBinary(firmware);
		
		// Авторизуемся для сервера
		//if (! auth()) return "Не пройдена авторизация";
		
		// Считываем uuid платы
		var uuid;
		try
		{
			uuid=cpuId.stm32f2xx_uuid();
		} catch (e)
		{
			return "Ошибка чтения серийного номера";
		}

		// без получения сертификатов
		
		// Запрашиваем сертификаты
		/*var certs;
		try
		{
			certs=get_certs( { login: LOGIN, password: PASSWORD, uuid: uuid, type: '(fire|security)_alarm', model: "РА-20" } );
			if ( (! ('ca' in certs)) ||
				 (! ('cert' in certs)) ||
				 (! ('key' in certs)) )
				throw new Error("no required field in response");
		} catch (e)
		{
			print("RPC error: "+e+"\n");
			unAuth();
			return "Ошибка получения сертификатов";
		}
		
		// Добавляем сертификаты к прошивке
		var CA=base64.decode(certs.ca);
		pack.u16(CA.length, bin, CA_AT+0);
		system.arrayCopy(bin, CA_AT+2, CA);
		
		var CERT=base64.decode(certs.cert);
		pack.u16(CERT.length, bin, CERT_AT+0);
		system.arrayCopy(bin, CERT_AT+2, CERT);
		
		var KEY=base64.decode(certs.key);
		pack.u16(KEY.length, bin, KEY_AT+0);
		system.arrayCopy(bin, KEY_AT+2, KEY);*/
		
		// Сохраняем файл для прошивки
		fs.writeBinary("tmp/can_eth.bin", bin);
		
		// Запускаем программирование
		ui.progress(-1);
		if (! stm32.write("tmp/can_eth.bin")) return "Ошибка записи в чип";
		
		// Удаляем временный файл
		fs.remove("tmp/can_eth.bin");

		// прошиваем серийный номер
		// var devconfig = getDeviceConfig();
		// ui.yesno() "версия: " + devconfig.message;
		if (system.os == "windows")
		{
			var serial = askSerialOrQR();

			if (serial.status)
			{
				burnSerial(serial.message);
				// конфигурация по умолчанию
				stm32.write("firmware/afas/can-eth/config/default-cfg.bin",false,0x08008000);
			}
			else
			{
				// конфигурация по умолчанию
				stm32.write("firmware/afas/can-eth/config/default-cfg.bin",false,0x08008000);
				return "Прошивка обновлена. Ошибка записи серийного: " + serial.message;
			}
		}

		// Сообщаем серверу, что прошивка удачная
		//flash_result( { login: LOGIN, password: PASSWORD, uuid: uuid, fw_ver: version } );


		// Успешно
		return "";
	};

	exports.eraseFlash = function() {

		ui.progress(0);
		// проверка подключения
		var uuid;
		try
		{
			uuid=cpuId.stm32f2xx_uuid();
		} catch (e)
		{
			return "Ошибка чтения серийного номера";
		}
		ui.progress(-1);
		if (! stm32.erase()) return "Ошибка стирания";
		
		return "";
	}

	function getDeviceConfig()
	{
		// читаем версию, должна быть "CAN-Eth_v1.08"
		var emptyData = new Array();
		//fs.writeBinary("tmp/device-config.bin",emptyData);
		//stm32.read("tmp/device-config.bin",0x08010200,13);
		//var configData = fs.readBinary("tmp/device-config.bin");
		var configData = fs.readBinary("/home/rey/work/device-config.bin");
		var str = '';
		for (var i = 0; i < configData.length; i++)
			str += String.fromCharCode(configData[i]);
		
		if (str == "CAN-Eth_v1.08")
			return 	{
				status: true,
				config_version: str
			};
		else
			return 	{
				status: false,
				config_version: str
			};
	}

	function askSerialOrQR()
	{
		var serial_rec = ui.ask("Введите серийный номер:");
		if (! serial_rec)
			return 	{
						status: false,
						message: "Не введён серийный номер"
					}

		if (! serial_rec.match(/^-?[0-9]+$/)) 
		{
			// проверка QR
			serial_rec=Utils.fixRus(serial_rec);
			var json;
			try
			{
				json=JSON.parse(serial_rec);
			} catch (e)
			{
				return 	{
							status: false,
							message: "Неверный формат QR-кода"
						};
			}
			if (json.model != "RA-20") 
				return 	{
							status: false,
							message: "QR-код от другого устройства"
						};

			return 	{
						status: true,
						message: json.sn.toString()
					};
		}
		else
		{
			// проверка на цифровой формат
			if (! serial_rec.match(/^-?[0-9]+$/)) 
				return 	{
							status: false,
							message: "Неверный формат числа\n"
						};
			if (serial_rec.length > 20)
				return 	{
							status: false,
							message: "Длина серийного номера больше 20 символов\n"
						};
			if (serial_rec.length < 10)
				return 	{
							status: false,
							message: "Длина серийного номера меньше 10 символов\n"
						};
			return 	{
						status: true,
						message: serial_rec
					};
		}
	}

	function askSerial() {

		var serial = Utils.ask_dec("Введите серийный номер:", 10, 20);
		return serial;
	}

	function getSerialInfo() {

		// если серийного номера нет - то возвращает статус записи и адрес для последующей записи
		// если серийный номер есть, то возвращает его статус записи, значение, адрес,
		// адрес для последующей записи, количество оставшихся записей
		
		// адреса для серийных номеров
		var snAddresses = [0x1FFF7800,0x1FFF78A0,0x1FFF7820,0x1FFF7840,0x1FFF7860,0x1FFF7880];

		var emptyData = new Array();

		fs.writeBinary("tmp/device-serial.bin",emptyData);
		stm32.read("tmp/device-serial.bin",snAddresses[0],21); // 21 - максимальная длина записанного ранее серийника

		var snAtMemoryBin = fs.readBinary("tmp/device-serial.bin");
		if (snAtMemoryBin[0] == 0xFF)
			return 	{
						status: false,
						newRecordAddr: snAddresses[0]
					};	// нет серийного номера на устройстве
		
		// если что-то записано в первом, то проверим по остальным адресам 
		fs.writeBinary("tmp/serial-rewrited.bin",emptyData);

		var recordIndex = 0;
		for (var i = 1; i < snAddresses.length; i++)
		{
			stm32.read("tmp/serial-rewrited.bin",snAddresses[i],21);
			snAtMemoryBin = fs.readBinary("tmp/serial-rewrited.bin");
			if (snAtMemoryBin[0] == 0xFF)
			{
				if (i != 1)
				{
					stm32.read("tmp/device-serial.bin",snAddresses[i - 1],21);
				}
				recordIndex = i - 1;
				snAtMemoryBin = fs.readBinary("tmp/device-serial.bin");
				break;
			}
		}

		fs.remove("tmp/serial-rewrited.bin");
		var s = "";
		for (var i=1; i<snAtMemoryBin[0] + 1; i++)
		{
			s+=Utils.toHex(snAtMemoryBin[i],1);
		}

		fs.remove("tmp/device-serial.bin");
		if (recordIndex + 1 != snAddresses.length)
		{
			// есть место для перезаписи
			return 	{
						status: true,
						value: s,
						recordAddr: snAddresses[recordIndex],
						newRecordAddr: snAddresses[recordIndex + 1],
						remain: snAddresses.length - 1 - recordIndex
					};
		}
		else
		{
			// нет места для перезаписи
			return 	{
						status: true,
						value: s,
						recordAddr: snAddresses[recordIndex],
						newRecordAddr: 0
					};
		}
	}

	function burnSerial(serialStr){

		// здесь нет проверки на валидность серийника
		// предполагается, что она выполнена
		// формат: первые два символа в строке - длина, остальные - серийник

		// записываем словами по четыре байта (если длина слова (с учётом байта length)
		// некратна 4 - то остаток пишем по одному байту)

		var serialData = processSerialString(serialStr);
		fs.writeBinary("tmp/serial.bin",serialData);

		// проверка серийного номера на устройстве

		var serial = getSerialInfo();

		if (serial.status)
		{
			if (serial.newRecordAddr != 0)
			{
				if (!ui.yesno("Cерийный номер уже установлен (" +serial.value+ ").\n\nПерезаписать? (допустимое число попыток: " +serial.remain+ ")"))
				{
					return "";
				}
			}
			else
			{
				ui.message("серийный номер уже установлен\n" +serial.value+ ". Количество перезаписей закончилось");
				return "";
			}
		}

		// прошиваем серийником
		if (! stm32.write("tmp/serial.bin",false,serial.newRecordAddr))
		{
			fs.remove("tmp/serial.bin");
			return "Ошибка записи в чип";
		}
		else
		{
			// считываем записанный серийник
			var emptyArr = new Array();

			fs.writeBinary("tmp/serial-test.bin",emptyArr);
			stm32.read("tmp/serial-test.bin",serial.newRecordAddr + 1,serialData[0]);
			var serialAtMemoryBin = fs.readBinary("tmp/serial-test.bin");
			var s="";
			for (var i=0; i<serialData[0]; i++)
				s+=Utils.toHex(serialAtMemoryBin[i],1);

			ui.message("серийный номер устройства\n" +s);
			fs.remove("tmp/serial-test.bin");
			fs.remove("tmp/serial.bin");

			return s;
		}
	}

	function processSerialString(serialStr){

		var result = new Array();

		result.push(serialStr.length);
		for (var i = 0; i < serialStr.length; i++)
			result.push(parseInt(serialStr[i]));

		return result;
	}
	
})(typeof exports === 'undefined' ? this['_can_eth_js']={} : exports);
