// Добавляем удобные функции

String.prototype.endsWith = function(str) {
	return this.substring(this.length - str.length) == str;
};

String.prototype.startsWith = function(str) {
	return this.substring(0, str.length) == str;
};


// Создаем временный каталог, если его нет
try
{
	fs.mkdir("tmp");
} catch (e){}


// Выбор COM-порта
var COM;
function selectCom()
{
	var v=ui.selectCom("Выберите COM-порт:", COM);
	if (! v) return false;
	COM=v;
	return true;
}


// Авторизация
var LOGIN, PASSWORD;
function auth()
{
	if ( (LOGIN===undefined) &&
		 (PASSWORD===undefined) )
	{
		var r=ui.login("Авторизация");
		if (! r) return false;
		LOGIN=r[0];
		PASSWORD=r[1];
	}
	
	return true;
}

function unAuth()
{
	LOGIN=undefined;
	PASSWORD=undefined;
}


// Подключаем модули
var stm8 = require("scripts/stm8");
var stm32 = require("scripts/stm32");
var spiFlash = require("scripts/spiflash");
var nRFflash = require("scripts/nrf");
var Serial = require("scripts/serial");
var cpuId = require("scripts/cpuid");
var Utils = require("scripts/utils");
var jsonrpc = require("scripts/jsonrpc");
var esptool = require("scripts/esptool");


function stm8_hex(part, hexfile)
{
	ui.progress(0);
	
	print("Unlocking...\n");
	stm8.unlock(part);	// разблокировка не обязательна, т.к. некоторые чипы ее не поддерживают
	ui.progress(25);
	
	print("Burning...\n");
	if (! stm8.write(part, "flash", hexfile)) return "Ошибка записи в чип";
	ui.progress(75);
	
	print("Verifying...\n");
	if (! stm8.verify(part, "flash", hexfile)) return "Ошибка проверки записи";
	ui.progress(100);
	
	return "";
}


function stm8_erase(part)
{
	ui.progress(0);
	
	print("Unlocking...\n");
	stm8.unlock(part);	// разблокировка не обязательна, т.к. некоторые чипы ее не поддерживают
	
	print("Burning Flash...\n");
	if (! stm8.write(part, "flash", "firmware/zero32k.bin")) return "Ошибка записи в чип";
	ui.progress(75);
	
	print("Burning EEPROM...\n");
	if (! stm8.write(part, "eeprom", "firmware/zero1k.bin")) return "Ошибка записи в чип";
	ui.progress(100);
	
	return "";
}


function stm32_hex(hexfile)
{
	ui.progress(-1);
	if (! stm32.write(hexfile)) return "Ошибка записи в чип";
	
	return "";
}


function stm32_bin(binfile)
{
	ui.progress(-1);
	if (! stm32.write(binfile)) return "Ошибка записи в чип";
	
	return "";
}


function stm32_erase(binfile)
{
	ui.progress(-1);
	if (! stm32.erase()) return "Ошибка стирания";
	
	return "";
}


function spiFlash_bin(binfile)
{
	ui.progress(-1);
	
	if (! spiFlash.write(binfile)) return "Ошибка записи в память";
	
	return "";
}


function avr_boot_pkg(pkgfile)
{
	if (! selectCom()) return "";
	if (! require("scripts/avr_boot").pkg(pkgfile)) return "Ошибка записи";
	
	return "";
}


// Поиск всех прошивок в каталоге
function findFirmwares()
{
	var arr={};
	
	for (var i=0; i<arguments.length; i++)
	{
		var path=arguments[i];
		
		fs.readdir(path).forEach( function(name) {
			var info =
				/^(boot\+)?(.*)[_\-](\d+-\d+\(\d+\))__(\d+-\d+-\d+)__(\d+[\-\.]\d+)\./.exec(name) ||		// new build
				/^(boot\+)?(.*)[_\-](r?\d+-\d+#\d+)__(\d+-\d+-\d+)__(\d+[\-\.]\d+)\./.exec(name) ||			// new release
				/^(boot\+)?(.*)[_\-](\d+.\d+.\d+)__(\d+-\d+-\d+)__(\d+[\-\.]\d+)\./.exec(name) ||			// new release format
				/^(boot\+)?(.*)[_\-](#\d+\.\d+)__(\d+-\d+-\d+)__(\d+[\-\.]\d+)\./.exec(name) ||				// old build
				/^(wifi_)?(.*)[_\-]build(\d+)\./.exec(name);												// wifi build
			if (info)
			{
				var key=info[2];
				var version=info[3];
				var date="";
				var time="";
				
				if (info[4]) date=info[4].replace(/-/g, '.');
				if (info[5]) time=info[5].replace(/-/g, ':');
				
				arr[key] =  {
						key: key,
						filename: path+"/"+name,
						version: version,
						dt: date+"  "+time,
						ver_dt: version+ "  "+date+"  "+time,
					};
			} else
			{
				//print("Bad file name: '"+name+"'\n");
			}
		} );
	}
	
	return arr;
}



// Обработчик QR-кодов
var QR=function(qr) {
		// Получаем имя прошивки и параметры
		var params=qr.split('#');
		var firmware=params[0];
		params.splice(0, 1);
		
		// Ищем скрипт
		try
		{
			return require("scripts/qr/"+firmware).run(params);
		} catch (e)
		{
			// Ошибка загрузки скрипта
			print("Script failed: "+e+"\n");
			return "Неверный QR-код !";
		}
	};


// Создаем меню
var Menu=[];
load("scripts/afas/menu.js");


// Получаем версию флэшера для установки заголовка
var WindowTitle;
try
{
	var ver=JSON.parse(fs.read("version.json"));
	WindowTitle="Программатор устройств Rubetek АПС (#"+ver.commit+" от "+ver.date+")";
} catch (e)
{
	print("version.json error:\n", e, "\n");
}



/*Menu.push( { name: "Test", run: do_test } );

function do_test()
{
	var result=ui.askNumber("Hello world", 0, 12345);
	print("result="+result+"\n");
	
	return "";
}*/
